/* 
 * lstat.c 
 *
 * Виводить атрибути заданого файлу.
 * Ілюструє порядок оперування атрибутами файлів.
 *
 */

#include <libgen.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <time.h>


int main(int argc, char *argv[])
{
        struct stat st;
        char *ptype;

        /* Перевіряє наявність аргумента. */
        if (argc == 1) {
                fprintf(stderr, "Usage: %s filename\n", 
                                        basename(argv[0]));
                exit(EXIT_FAILURE);
        }

        /* Отримує метадані файлу і зберігає їх в структурі st. */
        if (lstat(argv[1], &st) != 0) {
                perror("lstat()");
                exit(EXIT_FAILURE);
        }

        /* Визначає тип файлу. */
        /* Звичайний файл */
        if (S_ISREG(st.st_mode)) ptype = "regular file";
        /* Каталог */
        else if (S_ISDIR(st.st_mode)) ptype = "directory";
        /* Символічний зв'язок */
        else if (S_ISLNK(st.st_mode)) ptype = "symbolic link";
        /* Символьний пристрій */
        else if (S_ISCHR(st.st_mode)) ptype = "character device";
        /* Блочний пристрій */
        else if (S_ISBLK(st.st_mode)) ptype = "block device";
        /* Сокет */
        else if (S_ISSOCK(st.st_mode)) ptype = "socket";
        /* Іменований канал */
        else if (S_ISFIFO(st.st_mode)) ptype = "named pipe (fifo)";
        else ptype = "unknown type";

        /* Виводить тип файлу. */
        printf("type = %s\n", ptype);
        /* Виводить список контролю доступу до файлу. */
        printf("perm = %o\n", st.st_mode & ~S_IFMT);
        /* Виводить номер індексного дескриптора. */
        printf("inode = %lu\n", st.st_ino);
        /* Виводить кількість жорстких зв'язків. */
        printf("nlink = %u\n", st.st_nlink);
        /* Виводить старший та молодший номери пристрою,
           на якому зберігається файл. */
        printf("dev = (%u, %u)\n", major(st.st_dev), minor(st.st_dev));
        /* Виводить ідентифікатор користувача-власника.*/
        printf("UID = %u\n", st.st_uid);
        /* Виводить ідентифікатор групи-власника. */
        printf("GID = %u\n", st.st_gid);
        if (S_ISCHR(st.st_mode) || S_ISBLK(st.st_mode))
                /* Для файлів пристроїв - виводить старший та молодший
                   номери пристрою, з яким зв'язаний файл. */
                printf("rdev = (%u, %u)\n", major(st.st_rdev), minor(st.st_rdev));
        /* Виводить розмір. */
        printf("size = %lu\n", st.st_size);
        /* Виводить час останнього доступу. */
        printf("atime = %s", ctime(&st.st_atime));
        /* Виводить час останньої модифікації. */
        printf("mtime = %s", ctime(&st.st_mtime));
        /* Виводить час створення. */
        printf("ctime = %s", ctime(&st.st_ctime));

        exit(EXIT_SUCCESS);
}
